/* ============ */
/* pokrprob.c	*/
/* ============ */
#include <defcodes.h>
#include <miscdefs.h>
#include <mconf.h>
/* ==================================================================== */
/* CalcPokerProbs - Calculates Five Probabilities for Poker Test	*/
/* ==================================================================== */
void
CalcPokerProbs(int HandSize, int DVal, double *PokerProbVals)
{
    int     r;
    int     i;
    double  DkPow;

    /* ---------------------------------------------------------------- */
    /* HandSize	     -	Number of Cards in a Hand			*/
    /* DVal	     -	Value of Data Width    				*/
    /*			Range of Variates is (0, DVal-1)		*/
    /* PokerProbVals -	Probabilities Associated with Each Type of Hand	*/
    /*			There will be HandSize of These			*/
    /* ---------------------------------------------------------------- */
    DkPow = powi((double) DVal, HandSize-1);

    for (r = 1; r <= HandSize; ++r)
    {
	PokerProbVals[r - 1] = (double)Stirling2(HandSize, r) / DkPow;

	for (i = DVal - 1; i >= DVal + 1 - r; --i)
	{
	    PokerProbVals[r - 1] *= i;
	}
    }
}
